<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Proveedor extends Model 
{

    protected $table = 'proveedor';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function remito()
    {
        return $this->hasMany('App\Models\Remito');
    }

    public function orden()
    {
        return $this->hasMany('App\Models\OrdenCompra');
    }

    public function ordenPago()
    {
        return $this->hasMany('App\Models\OrdenPago');
    }

}